<?php
/**
 * Got A Sale Uninstall
 *
 * Removes all plugin options, WC API keys, and scheduled cron events on uninstall.
 */

if ( ! defined( 'WP_UNINSTALL_PLUGIN' ) ) {
	exit;
}

// Delete all gotasale options
delete_option( 'gotasale_site_token' );
delete_option( 'gotasale_store_name' );
delete_option( 'gotasale_license_key' );
delete_option( 'gotasale_notification_settings' );
delete_option( 'gotasale_available_channels_cache' );
delete_option( 'gotasale_plan_status' );
delete_option( 'gotasale_registration_status' );
delete_option( 'gotasale_wc_api_configured' );
delete_option( 'gotasale_wc_permissions' );

// Clean up WC API keys created by the plugin
global $wpdb;
$wpdb->delete(
	$wpdb->prefix . 'woocommerce_api_keys',
	array( 'description' => 'Got A Sale - Store Manager' ),
	array( '%s' )
);
$wpdb->delete(
	$wpdb->prefix . 'woocommerce_api_keys',
	array( 'description' => 'GotASale - Store Manager' ),
	array( '%s' )
);

// Clear scheduled cron events
wp_clear_scheduled_hook( 'gotasale_retry_registration' );
wp_clear_scheduled_hook( 'gotasale_wc_api_setup_retry' );
