{*
 * GotASale PrestaShop Module — Configuration Page
 *}

<div class="panel">
    <div class="panel-heading">
        <i class="icon-cogs"></i> {l s='GotASale — Order Notifications' mod='gotasale'}
    </div>

    <div class="panel-body">
        <div class="alert alert-info">
            <p><strong>{l s='Site Token:' mod='gotasale'}</strong></p>
            <code style="font-size: 1.1em; padding: 8px 12px; display: inline-block; background: #f5f5f5; border: 1px solid #ddd; border-radius: 4px; user-select: all;">{$site_token|escape:'html':'UTF-8'}</code>
            <p class="help-block" style="margin-top: 8px;">
                {l s='Use this token to link notification channels (Telegram, Discord, Teams, Google Chat, Slack) to your store.' mod='gotasale'}
            </p>
        </div>

        {* Pending Links *}
        {if $pending_links && count($pending_links) > 0}
            <div class="alert alert-warning">
                <h4>{l s='Pending Link Requests' mod='gotasale'}</h4>
                <p>{l s='Confirm these requests to start receiving notifications:' mod='gotasale'}</p>
                <table class="table table-striped" style="margin-top: 10px;">
                    <thead>
                        <tr>
                            <th>{l s='Platform' mod='gotasale'}</th>
                            <th>{l s='Channel' mod='gotasale'}</th>
                            <th>{l s='Code' mod='gotasale'}</th>
                            <th>{l s='Expires' mod='gotasale'}</th>
                            <th>{l s='Action' mod='gotasale'}</th>
                        </tr>
                    </thead>
                    <tbody>
                        {foreach from=$pending_links item=link}
                            <tr>
                                <td><span class="badge">{$link.platform|escape:'html':'UTF-8'}</span></td>
                                <td>{$link.chat_title|escape:'html':'UTF-8'}</td>
                                <td><code>{$link.confirm_code|escape:'html':'UTF-8'}</code></td>
                                <td>{$link.expires_at|escape:'html':'UTF-8'}</td>
                                <td>
                                    <form method="post" action="{$confirm_action|escape:'html':'UTF-8'}" style="display: inline;">
                                        <input type="hidden" name="confirm_code" value="{$link.confirm_code|escape:'html':'UTF-8'}">
                                        <button type="submit" name="submitGotaSaleConfirm" class="btn btn-success btn-sm">
                                            <i class="icon-check"></i> {l s='Confirm' mod='gotasale'}
                                        </button>
                                    </form>
                                </td>
                            </tr>
                        {/foreach}
                    </tbody>
                </table>
            </div>
        {/if}

        {* Test Notification *}
        <div class="well" style="margin-top: 15px; background: #f0fff4; border-color: #c3e6cb;">
            <h4 style="margin-top: 0;">{l s='Test Notification' mod='gotasale'}</h4>
            <p>{l s='Send a test notification to all linked channels to verify your setup.' mod='gotasale'}</p>
            <form method="post" action="{$confirm_action|escape:'html':'UTF-8'}" style="display: inline;">
                <button type="submit" name="submitGotaSaleSendTest" class="btn btn-success">
                    <i class="icon-paper-plane"></i> {l s='Send Test Notification' mod='gotasale'}
                </button>
            </form>
        </div>

        <hr>

        <h4>{l s='How to Connect' mod='gotasale'}</h4>
        <ol>
            <li>{l s='Copy the Site Token above.' mod='gotasale'}</li>
            <li>{l s='Open your notification channel (Telegram, Discord, Teams, Google Chat, or Slack).' mod='gotasale'}</li>
            <li>{l s='Send the link command with your token (e.g. /start YOUR_TOKEN in Telegram).' mod='gotasale'}</li>
            <li>{l s='Come back here and confirm the pending link request.' mod='gotasale'}</li>
            <li>{l s='You\'ll start receiving order notifications immediately!' mod='gotasale'}</li>
        </ol>

        <hr>

        <h4>{l s='Settings' mod='gotasale'}</h4>
        <form method="post" action="{$confirm_action|escape:'html':'UTF-8'}">
            <div class="form-group">
                <label for="GOTASALE_API_URL">{l s='API URL' mod='gotasale'}</label>
                <input type="text" name="GOTASALE_API_URL" id="GOTASALE_API_URL"
                       value="{$api_url|escape:'html':'UTF-8'}"
                       class="form-control" style="max-width: 400px;">
                <p class="help-block">{l s='Only change this if you\'re using a custom GotASale server.' mod='gotasale'}</p>
            </div>
            <button type="submit" name="submitGotaSaleSettings" class="btn btn-primary">
                <i class="icon-save"></i> {l s='Save Settings' mod='gotasale'}
            </button>
        </form>
    </div>
</div>
